from __future__ import annotations

import json
from pathlib import Path
from typing import Any, Dict

from .utils import ensure_logs_directory, timestamp


def write_json_report(name: str, data: Dict[str, Any]) -> Path:
    logs_dir = ensure_logs_directory()
    file_path = logs_dir / f"{name}_{timestamp()}.json"
    file_path.write_text(json.dumps(data, indent=2, default=str), encoding="utf-8")
    return file_path


def write_text_log(name: str, content: str) -> Path:
    logs_dir = ensure_logs_directory()
    file_path = logs_dir / f"{name}_{timestamp()}.txt"
    file_path.write_text(content, encoding="utf-8")
    return file_path

